#!/bin/sh

if [ $# -ne 1 ]; then
  echo "usage. $0 filename"
  exit 255
fi

DIR=`dirname "${0}"`

FILENAME=$1

USER=`"${DIR}/get_parameter/get_ftp_user_from_csv.sh" "${FILENAME}"`
PASS=`"${DIR}/get_parameter/get_ftp_password_from_csv.sh" "${FILENAME}"`

ROOTFS_RO=`"${DIR}/check_rootfs_ro.sh"`

# rootfs read write
if [ ${ROOTFS_RO} == "ro" ];then
  mount -o rw,remount /
fi

rm /etc/vsftpd/users.lst
rm /etc/vsftpd/vsftpd-virtual-user.db

echo $USER > /etc/vsftpd/users.lst
echo $PASS >> /etc/vsftpd/users.lst

db_load -T -t hash -f /etc/vsftpd/users.lst /etc/vsftpd/vsftpd-virtual-user.db

# rootfs read only
if [ ${ROOTFS_RO} == "ro" ];then
  mount -o ro,remount /
fi

# restart ftpd
/etc/init.d/vsftpd restart

# success
exit 0
